% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODEmorris.ODEnetwork.R
\name{ODEmorris.ODEnetwork}
\alias{ODEmorris.ODEnetwork}
\title{Morris Screening for Objects of Class \code{ODEnetwork}}
\usage{
\method{ODEmorris}{ODEnetwork}(mod, pars, times, binf = 0, bsup = 1,
  r = 500, design = list(type = "oat", levels = 10, grid.jump = 1),
  scale = TRUE, ode_method = "lsoda", parallel_eval = FALSE,
  parallel_eval_ncores = NA, ...)
}
\arguments{
\item{mod}{[\code{ODEnetwork}]\cr
list of class \code{ODEnetwork}.}

\item{pars}{[\code{character(k)}]\cr
names of the parameters to be included as input variables in Morris 
screening. All parameter names must be contained in 
\code{names(ODEnetwork::createParamVec(mod))} and must not be derivable 
from other parameters supplied (e.g. \code{"k.2.1"} can be derived from 
\code{"k.1.2"}, so supplying \code{"k.1.2"} suffices).}

\item{times}{[\code{numeric}]\cr
points of time at which the sensitivity analysis should be executed (vector
of arbitrary length). The first point of time must be greater than zero.}

\item{binf}{[\code{character(1} or \code{k)}]\cr
vector of lower borders of possible values for the \code{k} input 
parameters. If they are all equal, a single value can be set.}

\item{bsup}{[\code{character(1} or \code{k)}]\cr
vector of upper borders of possible values for the \code{k} input 
parameters. If they are all equal, a single value can be set.}

\item{r}{[\code{integer(1)}]\cr
if of length 1, the number of repetitions of the \code{design}. If of 
length 2, a space-filling optimization of the sampling design is used, see 
\code{\link[sensitivity]{morris}}. However, this space-filling optimization
might lead to long runtimes, so length 1 is recommended for \code{r}. 
Defaults to 500.}

\item{design}{[\code{list}]\cr
a list specifying the design type and its parameters,
cf. \code{\link[sensitivity]{morris}}.}

\item{scale}{[\code{logical(1)}]\cr
if \code{TRUE}, scaling is done for the input design of experiments after 
building the design and before calculating the elementary effects,
cf. \code{\link[sensitivity]{morris}}. Defaults to \code{TRUE}, which is
highly recommended if the factors have different orders of magnitude, see
\code{\link[sensitivity]{morris}}.}

\item{ode_method}{[\code{character(1)}]\cr
method to be used for solving the ODEs in situations where the solution has
to be determined numerically, see \code{\link[deSolve]{ode}} for details.
Defaults to \code{"lsoda"}.}

\item{parallel_eval}{[\code{logical(1)}]\cr
logical indicating if the evaluation of the ODE model shall be performed
parallelized.}

\item{parallel_eval_ncores}{[\code{integer(1)}]\cr
number of processor cores to be used for parallelization. Only applies if
\code{parallel_eval = TRUE}. If set to \code{NA} (as per default) and 
\code{parallel_eval = TRUE}, 1 processor core is used.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
List of class \code{ODEmorris} of length \code{2 * nrow(mod$state)} 
  containing in each element a matrix for one state variable (all components 
  of the 2 state variables are analyzed independently). The matrices 
  themselves contain the Morris screening results for all timepoints (rows: 
  \code{mu, mu.star} and \code{sigma} for every parameter; columns: 
  timepoints).
}
\description{
\code{ODEmorris.ODEnetwork} performs a sensitivity analysis for objects of 
class \code{ODEnetwork} using the Morris screening method.
Package \code{ODEnetwork} is required for this function to work.
}
\details{
If the object of class \code{ODEnetwork} supplied for \code{mod} doesn't
  include any events, the solution of the ODE network is determined 
  analytically using \code{\link[ODEnetwork]{simuNetwork}}. In the presence
  of events, \code{\link[ODEnetwork]{simuNetwork}} uses 
  \code{\link[deSolve]{ode}} to solve the ODE network numerically.
  
  The sensitivity analysis is done for all state variables and all
  timepoints simultaneously using \code{\link[sensitivity]{morris}} from the 
  package \code{sensitivity}.
  
  For non-ODE models, values for \code{r} are typically between 10 and 50.
  However, much higher values are recommended for ODE models (the default is
  \code{r = 500}).
}
\note{
In situations where the solution of the ODE model has to be determined 
  numerically, it might be helpful to try another ODE-solver if the 
  evaluation of the model function takes too long, (argument 
  \code{ode_method}). The \code{ode_method}s \code{"vode"}, \code{"bdf"}, 
  \code{"bdf_d"}, \code{"adams"}, \code{"impAdams"} and \code{"impAdams_d"} 
  might be faster than the default \code{"lsoda"}.
  
  If \code{\link[sensitivity]{morris}} throws a warning message stating
  "In ... keeping ... repetitions out of ...", try using a bigger number of 
  \code{levels} in the \code{design} argument (only possible for OAT design).
}
\examples{
##### A network of 4 mechanical oscillators connected in a circle #####
# Definition of the network using the package "ODEnetwork":
M_mat <- rep(2, 4)
K_mat <- diag(rep(2 * (2*pi*0.17)^2, 4))
K_mat[1, 2] <- K_mat[2, 3] <- 
  K_mat[3, 4] <- K_mat[1, 4] <- 2 * (2*pi*0.17)^2 / 10
D_mat <- diag(rep(0.05, 4))
library("ODEnetwork")
lfonet <- ODEnetwork(masses = M_mat, dampers = D_mat, springs = K_mat)
# The parameters to be included in the sensitivity analysis and their lower
# and upper boundaries:
LFOpars <- c("k.1", "k.2", "k.3", "k.4",
             "d.1", "d.2", "d.3", "d.4")
LFObinf <- c(rep(0.2, 4), rep(0.01, 4))
LFObsup <- c(rep(20, 4), rep(0.1, 4))
# Setting of the initial values of the state variables:
lfonet <- setState(lfonet, state1 = rep(2, 4), state2 = rep(0, 4))
# The timepoints of interest:
LFOtimes <- seq(25, 150, by = 2.5)
# Morris screening:
set.seed(283)
# Warning: The following code might take very long!
\donttest{
LFOres_morris <- ODEmorris(mod = lfonet,
                           pars = LFOpars,
                           times = LFOtimes,
                           binf = LFObinf,
                           bsup = LFObsup,
                           r = 500,
                           design = list(type = "oat", 
                                         levels = 10, grid.jump = 1),
                           scale = TRUE,
                           parallel_eval = TRUE,
                           parallel_eval_ncores = 2)
}

}
\seealso{
\code{\link[sensitivity]{morris}, \link{plot.ODEmorris}}
}
\author{
Frank Weber
}
