# Open Bodem Index Calculator (OBIC)

<!-- badges: start -->
[![Lifecycle: stable](https://img.shields.io/badge/lifecycle-stable-green.svg)](https://lifecycle.r-lib.org/articles/stages.html)
[![R-CMD-check](https://github.com/AgroCares/Open-Bodem-Index-Calculator/workflows/R-CMD-check/badge.svg)](https://github.com/AgroCares/Open-Bodem-Index-Calculator/actions)
[![Codecov test coverage](https://app.codecov.io/gh/AgroCares/Open-Bodem-Index-Calculator?branch=master)
<!-- badges: end -->

This R package can be used to calculate the Open Bodem Index (OBI). 
The OBI is a tool that evaluate the soil of agricultural fields based on four main criteria: chemical, physical, biological and management. 
These four criteria consist of more than 21 indicators to get a comprehensive picture of the soil. 
More information about the Open Bodem Index can be found at [Open Bodem Index](https://www.openbodemindex.nl).

## Installation

OBIC can be installed from GitHub using `remotes`. This will install the current development version from master branch. Stable versions can found at `releases`.
```
remotes::install_github("AgroCares/Open-Bodem-Index-Calculator")
library("OBIC")
```
## Documentation
Documentation of the R functions in the OBIC package can be found [here](https://agrocares.github.io/Open-Bodem-Index-Calculator/)

## More information
The [Open Bodem Index](https://www.openbodemindex.nl) (OBI) is a collaboration between Wageningen UR, NMI and FarmHack in collaboration with agricultural experts. 
The Open Bodem Index Calculator is a tool used by the OBI and developed by [NMI](https://www.nmi-agro.nl/).

![Logo of NMI](https://media.licdn.com/dms/image/C560BAQEYGcm4HjNnxA/company-logo_200_200/0?e=2159024400&v=beta&t=u40rJ7bixPWB2SAqaj3KCKzJRoKcqf0wUXCdmsTDQvw)
