% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SensTimePlot.R
\name{SensTimePlot}
\alias{SensTimePlot}
\title{Sensitivity analysis plot over time of the data}
\usage{
SensTimePlot(
  object,
  fdata = NULL,
  date.var = NULL,
  facet = FALSE,
  smooth = FALSE,
  nspline = NULL,
  ...
)
}
\arguments{
\item{object}{fitted neural network model or \code{array} containing the raw
sensitivities from the function \code{\link[NeuralSens]{SensAnalysisMLP}}}

\item{fdata}{\code{data.frame} containing the data to evaluate the sensitivity of the model.
Not needed if the raw sensitivities has been passed as \code{object}}

\item{date.var}{\code{Posixct vector} with the date of each sample of \code{fdata}
If \code{NULL}, the first variable with Posixct format of \code{fdata} is used as dates}

\item{facet}{\code{logical} if \code{TRUE}, function \code{facet_grid} from \code{ggplot2} is used}

\item{smooth}{\code{logical} if \code{TRUE}, \code{geom_smooth} plots are added to each variable plot}

\item{nspline}{\code{integer} if \code{smooth} is TRUE, this determine the degree of the spline used
to perform \code{geom_smooth}. If \code{nspline} is NULL, the square root of the length of the timeseries
is used as degrees of the spline.}

\item{...}{further arguments that should be passed to  \code{\link[NeuralSens]{SensAnalysisMLP}} function}
}
\value{
list of \code{geom_line} plots for the inputs variables representing the
sensitivity of each output respect to the inputs over time
}
\description{
Plot of sensitivity of the neural network output respect
to the inputs over the time variable from the data provided
}
\examples{
## Load data -------------------------------------------------------------------
data("DAILY_DEMAND_TR")
fdata <- DAILY_DEMAND_TR
fdata[,3] <- ifelse(as.data.frame(fdata)[,3] \%in\% c("SUN","SAT"), 0, 1)
## Parameters of the NNET ------------------------------------------------------
hidden_neurons <- 5
iters <- 250
decay <- 0.1

################################################################################
#########################  REGRESSION NNET #####################################
################################################################################
## Regression dataframe --------------------------------------------------------
# Scale the data
fdata.Reg.tr <- fdata[,2:ncol(fdata)]
fdata.Reg.tr[,3] <- fdata.Reg.tr[,3]/10
fdata.Reg.tr[,1] <- fdata.Reg.tr[,1]/1000

# Normalize the data for some models
preProc <- caret::preProcess(fdata.Reg.tr, method = c("center","scale"))
nntrData <- predict(preProc, fdata.Reg.tr)

#' ## TRAIN nnet NNET --------------------------------------------------------
# Create a formula to train NNET
form <- paste(names(fdata.Reg.tr)[2:ncol(fdata.Reg.tr)], collapse = " + ")
form <- formula(paste(names(fdata.Reg.tr)[1], form, sep = " ~ "))

set.seed(150)
nnetmod <- nnet::nnet(form,
                      data = nntrData,
                      linear.output = TRUE,
                      size = hidden_neurons,
                      decay = decay,
                      maxit = iters)
# Try SensTimePlot
NeuralSens::SensTimePlot(nnetmod, fdata = nntrData, date.var = NULL)
}
