% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cascade.R
\name{as_cascade_long}
\alias{as_cascade_long}
\title{Transform long data to cascade}
\usage{
as_cascade_long(data, cascade_node_name = "node_name",
  event_time = "event_time", cascade_id = "cascade_id", node_names = NULL)
}
\arguments{
\item{data}{\link{data.frame}, containing the cascade data 
with column names corresponding to the arguments provided to 
\code{cascade_node_names}, \code{event_time} and \code{cascade_id}.}

\item{cascade_node_name}{character, column name of \code{data} that specifies 
the node names in the cascade.}

\item{event_time}{character, column name of \code{data} that specifies the 
event times for each node involved in a cascade.}

\item{cascade_id}{character, column name of the cascade identifier.}

\item{node_names}{character, factor or numeric vector containing the names for each node. 
Optional. If not provided, node names are inferred from the cascade data.}
}
\value{
An object of class \code{cascade}. This is a list containing three
    (named) elements: 
    \enumerate{
        \item \code{"node_names"} A character vector of node names.
        \item \code{"cascade_nodes"} A list with one character vector per
            cascade containing the node names in order of the events.
        \item \code{"cascade_times"} A list with one element per cascade 
            containing the event times for the nodes in \code{"cascade_names"}.
    }
}
\description{
Create a cascade object from data in long format.
}
\details{
Each row of the data describes one event in the cascade. The data must 
contain at least three columns:
\enumerate{
   \item Cascade node name: The identifier of the node that experiences the 
       event.
   \item Event time: The time when the node experiences the event. Note that
       if the time column is of class date or any other special time class, 
       it will be converted to an integer with `as.numeric()`. 
   \item Cascade id: The identifier of the cascade that the event pertains to.
}
The default names for these columns are \code{node_name}, \code{event_time} 
and \code{cascade_id}. If other names are used in the \code{data} object the 
names have to be specified in the corresponding arguments (see argument 
documentation)
}
\examples{

df <- simulate_rnd_cascades(10, n_nodes = 20)
cascades <- as_cascade_long(df)
is.cascade(cascades)
}
