% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Powerlaw.R
\name{degree_distribution}
\alias{degree_distribution}
\title{Degree distribution of the network}
\usage{
degree_distribution(Network, name)
}
\arguments{
\item{Network}{a trophic network of class network}

\item{name}{a categorical variable that represent
the distribution model}
}
\value{
exports three principal results:
1. A list with network degree distribution values and with the value of each fit model
2. A list with each model results and AIC of the distribution models
3. A Ghraph of the degree distribution with the models adjust
In DDvalues, k represent the degree of the network and cumulative
the probability that each specie could be have this degree (pk).
Observation: In the graph, the zero values are not represented but this result are incorporate in the DF result
}
\description{
This function calculates the degree distribution of the network. First it
fits exponential, power law and truncated power law distribution models,
and calculates the AIC values to select the best fit, and finally it plots
the degree distribution in a log log scale showing the three fitted models
mentioned above against the observed distribution.
}
\examples{
library(NetworkExtinction)
data("net")
degree_distribution(net, name = "Test")

}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>

M.Isidora Avila Thieme <msavila@uc.cl>
}
