% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{PureIBNRGamma}
\alias{PureIBNRGamma}
\title{Pure IBNR exposure from a Gamma reporting delay distribution}
\usage{
PureIBNRGamma(IncDate, ExpDate, ValDate, shape, rate)
}
\arguments{
\item{IncDate}{A date -  the inception date of the period.}

\item{ExpDate}{A date -  the expiry date of the period. Must be greater than inception date.}

\item{ValDate}{A date -  the valuation date.}

\item{shape}{A positive real number - the shape parameter of the reporing delay's Gamma distribution.}

\item{rate}{A positive real number - the rate parameter of the reporing delay's Gamma distribution.}
}
\value{
Unearned and Pure IBNR exposure in days and as a percentage of the period's duration, where the reporting delay has a Gamma distribution with parameters \code{shape} and \code{rate}.
}
\description{
Pure IBNR exposure from a Gamma reporting delay distribution
}
\examples{
Dates = data.frame(
    inceptionDate = c("01/01/2006", "01/07/2006", "01/01/2007")
    ,expiryDate = c("31/12/2006", "30/06/2007", "31/12/2007")
)

Dates$inceptionDate<-as.POSIXct(Dates$inceptionDate, format="\%d/\%m/\%Y")

Dates$expiryDate<-as.POSIXct(Dates$expiryDate, format="\%d/\%m/\%Y")

ValuationDate<-as.POSIXct("30/10/2007", format="\%d/\%m/\%Y")

PureIBNRGamma(Dates$inceptionDate,Dates$expiryDate,ValuationDate,7,0.15)
}
