% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/origin_helper.r
\name{plot_performance}
\alias{plot_performance}
\title{A plot method combining a time series of performance results.}
\usage{
plot_performance(x, var = "rank", add = FALSE, offset = NULL,
  log = FALSE, col = 1, ylim = NULL, text.padding = 0.9, ...)
}
\arguments{
\item{x}{\code{data.frame} obtained by combined results from \code{\link{performance.origin}} with variables \code{X1} for time point, \code{start} for true origin, \code{est} for estimated origin, and performance variables}

\item{var}{character, variable to be plotted, \code{\link{performance.origin}} returns \code{rank}, \code{spj}, and \code{dist}, default is \code{'rank'}}

\item{add}{logical, should be added to another performance plot}

\item{offset}{\code{POSIXct}, starting time of spreading}

\item{log}{logical, should y-axis be logarithmized?}

\item{col}{numeric or character, color of lines}

\item{ylim}{numeric vector, range of y axis}

\item{text.padding}{a numeric value specifying the factor for the text position relative to the y values}

\item{...}{further graphical parameters passed to default \code{plot} function}
}
\description{
A plot method combining a time series of performance results.
}
\examples{
\dontrun{ 
### delays on Goettingen bus network
# compute effective distance
data(ptnGoe)
goenet <- igraph::as_adjacency_matrix(ptnGoe, sparse=FALSE)
p <- goenet/rowSums(goenet)
eff <- eff_dist(p)
# apply source estimation
data(delayGoe)
if (requireNamespace("aplyr", quietly = TRUE)) {
   res <- alply(.data=delayGoe[11:20,-c(1:2)], .margins=1, .fun=origin_edm, 
                distance=eff, silent=TRUE, .progress='text')
   perfGoe <- ldply(Map(performance, x = res, start = 2, list(graph = ptnGoe)))
   # performance plots
   plot_performance(perfGoe, var='rank', ylab='rank of correct detection', text.padding=0.5)
   plot_performance(perfGoe, var='dist', ylab='distance to correct detection')
}

### delays on Athens metro network
# compute effective distance
data(ptnAth)
athnet <- igraph::as_adjacency_matrix(ptnAth, sparse=FALSE)
p <- athnet/rowSums(athnet)
eff <- eff_dist(p)
# apply source estimation
data(delayAth)
if (requireNamespace("aplyr", quietly = TRUE)) {
   res <- alply(.data=delayAth[11:20,-c(1:2)], .margins=1, .fun=origin_edm, 
             distance=eff, silent=TRUE, .progress='text')
   perfAth <- ldply(Map(performance, x = res, start = as.list(delayAth$k0),
                     list(graph = ptnAth)))
   # performance plots
   plot_performance(perfAth, var='rank', ylab='rank of correct detection',text.padding=0.5)
   plot_performance(perfAth, var='dist', ylab='distance to correct detection')
}
}
}

