% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covFX.R
\name{covFX}
\alias{covFX}
\title{Generate estimated monadic covariate effects for estimated mmsbm model}
\usage{
covFX(fm, cov, shift, max.val = FALSE)
}
\arguments{
\item{fm}{An object of class \code{mmsbm}, a result of a call to \code{mmsbm}.}

\item{cov}{Character string identifying the monadic covariate to be shifted.}

\item{shift}{Numeric value specifying the desired increase or decrease in the monadic covariate.  The monadic predictor will be shifted by this value for all nodes and time periods.}

\item{max.val}{An optional numeric value specifying the maximum possible value for the monadic covariate.}
}
\value{
List with named components:
    \describe{
      \item{Overall Avg. Effect}{Overall average effect of the covariate shift on the predicted probability of edge formation.}
      \item{Avg. Effect by Time}{Vector of average effects of the covariate shift on the predicted probability of edge formation for each time period.}
      \item{Avg. Effect by Node}{Vector of average effects of the covariate shift on the predicted probability of edge formation for each node.}
      \item{Avg. Effect by Dyad}{Vector of average effects of the covariate shift on the predicted probability of edge formation for each node dyad.}
      \item{Avg. Effect Dyad-Time}{Vector of estimated effects of the covariate shift on the predicted probability of edge formation for each node dyad-time unit.}
    }
}
\description{
The function estimates the effect of a shift in monadic covariate values on the probability of edge formation in the network.
}
\examples{
library(NetMix)
## Load datasets
data("lazega_dyadic")
data("lazega_monadic")
## Estimate model with 2 groups
lazega_mmsbm <- mmsbm(SocializeWith ~ Coworkers,
                      ~  Age,
                      senderID = "Lawyer1",
                      receiverID = "Lawyer2",
                      nodeID = "Lawyer",
                      data.dyad = lazega_dyadic,
                      data.monad = lazega_monadic,
                      n.blocks = 2,
                      mmsbm.control = list(seed = 123, 
                                           hessian = FALSE))

## Compute effect of decreasing every lawyers' age by 10 years
fx_list <- covFX(lazega_mmsbm, cov = "Age", shift = -10)
fx_list[["Overall Avg. Effect of Age"]]

}
\author{
Santiago Olivella (olivella@unc.edu), Adeline Lo (aylo@wisc.edu), Tyler Pratt (tyler.pratt@yale.edu), Kosuke Imai (imai@harvard.edu)
}
