% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\docType{methods}
\name{NLset}
\alias{NLset}
\alias{set}
\alias{NLset,missing,agentMatrix,agentMatrix,character-method}
\alias{NLset,worldMatrix,missing,matrix,missing-method}
\alias{NLset,worldArray,missing,matrix,character-method}
\title{Set an agents variable}
\usage{
NLset(world, turtles, agents, var, val)

\S4method{NLset}{missing,agentMatrix,agentMatrix,character}(turtles,
  agents, var, val)

\S4method{NLset}{worldMatrix,missing,matrix,missing}(world, agents, val)

\S4method{NLset}{worldArray,missing,matrix,character}(world, agents, var,
  val)
}
\arguments{
\item{world}{WorldMatrix or worldArray object.}

\item{turtles}{AgentMatrix object representing the moving agents.}

\item{agents}{Matrix (ncol = 2) with the first column "pxcor" and the second
              column "pycor" representing the patches coordinates, or

              AgentMatrix object representing the moving agents.}

\item{var}{Character. Vector of the names of the selected \code{agents} variables.
If \code{agents} are patches and the \code{world} is a
\code{worldMatrix} object, \code{var} must not be provided. If
\code{agents} are patches and the \code{world} is a
\code{worldArray} object, \code{var} is the name of the layers to
use to define the patches
values. If \code{agents} are turtles, \code{var} is some of
the turtles' variable and can be any of the variables created
when turtles were created,
as well as any variable created with \code{turtlesOwn()}.}

\item{val}{Numeric or character. Vector of length 1 or length \code{NLcount(agents)}
           if \code{length(var) == 1}, or

           Matrix or Dataframe (ncol = \code{length(var)}, nrow = \code{NLcount(agents)}).
           Columns must be in the same order as \code{var}.}
}
\value{
WorldMatrix or worldArray object with the values \code{val} assigned to the patches
        variables \code{var}
        for the \code{agents}, or

        AgentMatrix representing the \code{turtles} with
        the values \code{val} assigned to the variables \code{var} for the \code{agents}.
}
\description{
Assign values to the \code{agents} for the selected variables.
}
\details{
If \code{agents} are patches, \code{world} must be provided and \code{turtles}
         must not be provided. If \code{agents} are turtles, \code{turtles} must be
         provided and \code{world} must not be provided.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
w1 <- NLset(world = w1, agents = patches(w1), val = 1)
# Set the patch[0,4] to 0
w1 <- NLset(world = w1, agents = patch(w1, 0, 4), val = 0)
of(world = w1, agents = patches(w1))

t1 <- createTurtles(n = 3, world = w1, heading = 0)
# Set the heading of turtle 0 to 180
t2 <- NLset(turtles = t1, agents = turtle(t1, who = 0), var = "heading", val = 180)
of(agents = t2, var = "heading") # c(180, 0, 0)


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#set}
}
\author{
Sarah Bauduin
}
