\name{SimulateTypeC}
\alias{SimulateTypeC}
\title{Simulation of the Generalized Thomas Model of Type C}
\description{
  Simulation of the generalized Thomas model of type C.
}
\usage{
  SimulateTypeC(pars, seed = NULL, parents.distinct = FALSE, plot = TRUE)
}
\arguments{
  \item{pars}{a named vector of containing the values of the model parameters
    (\code{mu1}, \code{mu2}, \code{nu1}, \code{nu2}, \code{sigma1},
    \code{sigma2}), where (\code{mu}\eqn{i}, \code{nu}\eqn{i},
    \code{sigma}\eqn{i}) is an intensity of parents, an expected number of
    descendants, a parameter of the dispersal kernel for superposed component
    \eqn{i} (\eqn{i = 1,2}), respectively.}
  \item{seed}{a positive integer, which is the seed for a sequence of uniform
    random numbers. The default seed is based on the current time.}
  \item{parents.distinct}{logical. If TRUE, points are distinguished by two
    groups specified by parameters (\code{mu1}, \code{nu1}, \code{sigma1})
    and (\code{mu2}, \code{nu2}, \code{sigma2}).}
  \item{plot}{logical. If \code{TRUE} (default), simulated parent points and
    offspring points are plotted.}
}
\details{
  Consider the two types of the Thomas model with parameters
  \eqn{(\mu_1, \nu_1, \sigma_1)}{(\mu1, \nu1, \sigma1)} and
  \eqn{(\mu_2, \nu_2, \sigma_2)}{(\mu2, \nu2, \sigma2)}.
  Parents' configuration and numbers of the offspring cluster sizes are
  generated by the two types of uniformly distributed parents
  \eqn{(x_i^k, y_i^k)} with
  \eqn{i=1,2,\dots,Poisson(\mu_k)}{i=1,2,...,Poisson(\muk)} for \eqn{k=1,2},
  respectively.

  Then, using series of different uniform random numbers \eqn{\{ U \}}{{U}} for
  different \eqn{i} and \eqn{j}, each of the offspring coordinates 
  \eqn{(x_j^{k,i}, y_j^{k,i})},
  \eqn{j=1,2,\dots,Poisson(\nu_k)}{j=1,2,...,Poisson(\nuk)}
  of the parents \eqn{(k,i)} with \eqn{k=1,2} is given by

  \deqn{x_j^{k,i} = x_i^k + r_k \cos(2 \pi U),}{%
        x_j^{k,i} = x_i^k + r_k cos(2\piU),}
  \deqn{y_j^{k,i} = y_i^k + r_k \sin(2 \pi U),}{%
        y_j^{k,i} = y_i^k + r_k sin(2\piU),}

  where 

  \deqn{r_k = \sigma_k \sqrt{-2 \log(1-U_k)}, \quad k = 1, 2,}{%
        r_k = \sigmak \sqrt{ -2log(1-Uk) }, \quad k = 1, 2,}

  with different random numbers \eqn{\{ U_k, U \}}{{Uk, U}} for different
  \eqn{k, i} and \eqn{j}.
}
\value{
  \item{parents}{a list containing two components named "\code{n}" and
    "\code{xy}" giving the number and the matrix of \code{(x,y)} coordinates of
    simulated parents points respectively. \code{xy}[1:\code{n}[1], 1:2] are
    generated from parameters (\code{mu1}, \code{nu1}, \code{sigma1}) and the
    remainder are generated from (\code{mu2}, \code{nu2}, \code{sigma2}).}
  \item{offspring}{a list containing two components named "\code{n}" and
    "\code{xy}" giving the number and the matrix of \code{(x,y)} coordinates of
     simulated offspring points respectively. \code{xy}[1:\code{n}[1], 1:2] are
     generated from parameters (\code{mu1}, \code{nu1}, \code{sigma1}) and
     the remainder are generated from (\code{mu2}, \code{nu2}, \code{sigma2}).}
}
\references{
  U. Tanaka, Y. Ogata and K. Katsura,
  Simulation and estimation of the Neyman-Scott type spatial cluster models,
  \emph{Computer Science Monographs} \bold{No.34}, 2008, 1-44.
  The Institute of Statistical Mathematics.
}
\examples{
pars <- c(mu1 = 5.0, mu2 = 9.0, nu1 = 30.0, nu2 = 150.0,
          sigma1 = 0.01, sigma2 = 0.05)
SimulateTypeC(pars, seed = 555)
}

\keyword{spatial}
