% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npred.R
\name{npred}
\alias{npred}
\title{Predict Y for new data by projecting the data onto the latent space defined by an NPLS model.}
\usage{
npred(model, newX)
}
\arguments{
\item{model}{NPLS model}

\item{newX}{New data organized in a matrix of (Inew x J x K) with Inew new subjects}
}
\value{
Ypred: vector of the predicted value(s) of Y for the new data
}
\description{
Predict Y for new data by projecting the data onto the latent space defined by an NPLS model.
}
\examples{
Y = as.numeric(as.factor(Cornejo2025$Tongue$mode1$GenderID))
Ycnt = Y - mean(Y)
model = triPLS1(Cornejo2025$Tongue$data, Ycnt, numComponents=1)
npred(model, Cornejo2025$Tongue$data[1,,])
}
