% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classifier.R
\name{VN.class}
\alias{VN.class}
\title{VN Classifier}
\usage{
VN.class(x, y, threshold = 0, order = NULL, point.est = NULL,
  location = "top", print.values = FALSE, print.equation = FALSE,
  plot = TRUE)
}
\arguments{
\item{x}{Complete dataset in matrix form.}

\item{y}{Column of data to be classified.}

\item{threshold}{Sets the coefficient threshold for independent variables.  Defaults to 0.}

\item{order}{Controls the number of partial moment quadrant means.  Defaults to smaller order to avoid overfitting}

\item{point.est}{Returns the fitted value for any value of the independent variable.  Use a vector of values for independent varaiables to return the multiple regression fitted value.}

\item{location}{Sets the legend location within the plot}

\item{print.values}{Defaults to FALSE, set to TRUE in order to return all fitted values for independent variable}

\item{print.equation}{Defaults to FALSE, set to TRUE in order to return the local coefficients}

\item{plot}{To plot regression or not.  Defaults to TRUE.}
}
\description{
Classifies data based on multiple logistic nonlinear regression (VN.reg)
}
\examples{
## Using 'iris' dataset where predictive attributes are columns 1:4, and the class is column 5.
\dontrun{VN.class(iris,5)}
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{classifier}
\keyword{logistic}
\keyword{nonlinear}
\keyword{regression,}

