% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMproject-package.R
\docType{package}
\name{NMproject-package}
\alias{NMproject}
\alias{NMproject-package}
\title{NMproject: Script Based 'NONMEM' Model Development}
\description{
Industrialisation of 'NONMEM'
  <https://www.iconplc.com/innovation/nonmem/> via fully and rapidly reusable 
  model development 'workflows' entirely within 'RStudio'. Quickly get started
  with new models by importing 'NONMEM' templates from the built-in code
  library. Manipulate 'NONMEM' code from within R either via the tracked 
  'manual edit' interface or 'programmatically' via convenience functions. 
  Script 'workflows' by piping sequences of model building steps from control 
  file creation, to execution, to post-processing and evaluation. Run caching 
  makes 'workflows' R markdown friendly for easy documentation of thoughts and
  modelling decisions alongside executable code. Share, reuse and recycle
  'workflows' for new problems.
}
\section{Package options}{


See \code{\link[=options]{options()}} for information on how to modify these:

\describe{
\item{system_cmd}{
See \code{?system_cmd}.
}
\item{system_nm}{
See \code{?system_nm}.
}
\item{quiet_run}{
Sets the default value for the \code{quiet} argument in \code{run_nm}.
}
\item{intern}{
Sets the default value for the \code{intern} argument in \code{run_nm}.
}
\item{available_nm_types}{
A list of NONMEM subroutine names.
This is modifiable in case future versions of NONMEM contain new
subroutines.
}
\item{nm_default_dirs}{
An optional (partially) named list of directories
to be used by \code{nm_create_analysis_project} to create the project
directory structure when making a new analysis project.
Required names are \code{"models"}, \code{"scripts"} and \code{"results"}.
By default these will be set to \code{"Models"}, \code{"Scripts"} and \code{"Results"},
respectively.  Additional characters (e.g. \code{"SourceData"}) correspond to
additional modelling directories to be created.
}
\item{kill_job}{
An optional function to kill jobs before they are started.
This is useful in infrastructures, where repeating a job conflicts with
other jobs writing into the same directories.  For example, in Slurm grids
this could be a function wrapper around a \code{system("scancel ...")}
call.
}
\item{nm.overwrite_behaviour}{
See \code{?overwrite_behaviour}.
}
\item{nm.force_render}{
Sets default value for the \code{force} argument in See \code{nm_render}.
}
\item{nm.cmd_default}{
Sets default \code{cmd} field for all nm objects.
See \code{?cmd} for more information.
The default value is "execute {ctl_name} -dir={run_dir}".
However in environments where a different command is needed, this is the
place to change it.
}
\item{nmtran_exe_path}{
Sets the value of the NMTRAN.exe program.  This may be deprecated in future
it is recommended to use \code{nm_tran_command()}.
See \code{?nm_tran_command} for more information.
}
\item{code_library_path}{
Path to code library.  By default this will point to the code library
within the NMproject installation directory.
See \code{?code_library} for more information.
}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://tsahota.github.io/NMproject/}
  \item \url{https://github.com/tsahota/NMproject}
  \item Report bugs at \url{https://github.com/tsahota/NMproject/issues}
}

}
\author{
\strong{Maintainer}: Tarj Sahota \email{t.sahota0@gmail.com} [copyright holder]

Other contributors:
\itemize{
  \item AstraZeneca [copyright holder]
  \item Nuria Buil Bruna \email{nuria.buil.bruna@gmail.com} [contributor]
  \item Stein Schalkwijk \email{steinschalkwijk@gmail.com} [contributor]
}

}
\keyword{internal}
