% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc.R
\name{cc}
\alias{cc}
\title{Create character vectors without quotation marks}
\usage{
cc(...)
}
\arguments{
\item{...}{The unquoted names that will become character values in
the returned vector.}
}
\value{
A character vector
}
\description{
When creating character vectors with several elements, it becomes
a lot of quotes to type. cc provides a simple way to skip the
quotes - but only for simple strings.
}
\details{
Don't use cc with any special characters - only
    alphanumerics and no spaces supported. Also, remember that
    numerics are converted using as.character. Eg, this means that
    leading zeros are dropped.
}
\examples{
cc(a,b,`a b`)
cc(a,b,"a b")
## be careful with spaces and special characters
cc( d)
cc(" d")
cc()
## Numerics are converted using as.character
cc(001,1,13e3)
}
\seealso{
cl
}
