$PROBLEM    PK
;@ Variables 17/20 @;
$INPUT ROW ID TIME EVID CMT AMT DV MDV DOSE

$DATA ./NMsimData_xgxr001_testsim1.csv
IGN=@

$SUBROUTINE ADVAN4 TRANS4
$PK
TVKA=THETA(1)
TVV2=THETA(2)
TVCL=THETA(3)
TVV3=THETA(4)
TVQ=THETA(5)
                   
KA=TVKA*EXP(ETA(1))
V2=TVV2*EXP(ETA(2))
CL=TVCL*EXP(ETA(3))
V3=TVV3*EXP(ETA(4))
Q=TVQ*EXP(ETA(5))

$ERROR
  IPRED=F
  IRES=DV-IPRED

  IF (IPRED.GT.1) THEN
    W = SQRT(IPRED**2*SIGMA(1,1)**2 + SIGMA(2,2)**2)
  ELSE
    W=1
  ENDIF

  IWRES=IRES/W
  Y=F+F*ERR(1)+ERR(2)

;-----------------------INITIAL ESTIMATES---------------------------------
$THETA  (0,0.181156) ; POPKA
$THETA  (0,0.042) ; POPCL
$THETA  (0,0.724699) ; POPV2
$THETA  (0,0.178351) ; POPV3
$THETA  (0,2269600) ; POPQ
$OMEGA  0.209987
$OMEGA  0.121444
$OMEGA  0.000169787
$OMEGA  0  FIX
$OMEGA  0  FIX
$SIGMA  0.105974
$SIGMA  0.00139307
$SIMULATION ONLYSIM (343108)

$TABLE      ROW TVKA TVV2 TVCL TVV3 TVQ KA V2 CL V3 Q PRED IPRED
NOPRINT FILE=xgxr001_testsim1.tab

