% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMexpandDoses.R
\name{NMexpandDoses}
\alias{NMexpandDoses}
\title{Transform repeated dosing events (ADDL/II) to individual dosing events}
\usage{
NMexpandDoses(
  data,
  col.time = "TIME",
  col.id = "ID",
  col.evid = "EVID",
  quiet = FALSE,
  as.fun
)
}
\arguments{
\item{data}{The data set to expand}

\item{col.time}{The name of the column holding the time on which
time since previous dose will be based. This is typically
actual or nominal time since first dose.}

\item{col.id}{The subject identifier. All new columns will be
derived within unique values of this column.}

\item{col.evid}{The name of the event ID column. This must exist
in data. Default is EVID.}

\item{quiet}{Suppress messages back to user (default is FALSE)}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say tibble::as_tibble) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}
}
\value{
A data set with at least as many rows as data. If doses
    are found to expand, these will be added.
}
\description{
Replaces single row repeated dosing events by multiple lines, then
reorders rows with respect to ID and TIME. If the row order is
different, you have to reorder the output manually.
}
