% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_mpd.R
\name{nlm_mpd}
\alias{nlm_mpd}
\title{nlm_mpd}
\usage{
nlm_mpd(ncol, nrow, resolution = 1, roughness = 0.5, rand_dev = 1,
  rescale = TRUE, verbose = TRUE)
}
\arguments{
\item{ncol}{[\code{numerical(1)}]\cr
Number of columns forming the raster.}

\item{nrow}{[\code{numerical(1)}]\cr
Number of rows forming the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{roughness}{[\code{numerical(1)}]\cr
Controls the level of spatial autocorrelation (!= Hurst exponent)}

\item{rand_dev}{[\code{numerical(1)}]\cr
Initial standard deviation for the displacement step (default == 1), sets the
scale of the overall variance in the resulting landscape.}

\item{rescale}{[\code{logical(1)}]\cr If \code{TRUE} (default), the values
are rescaled between 0-1.}

\item{verbose}{[\code{logical(1)}]\cr If \code{TRUE} (default), the user gets
a warning that the functions changes the dimensions to an appropriate one for
the algorithm.}
}
\value{
RasterLayer
}
\description{
Simulates a midpoint displacement neutral landscape model.
}
\details{
The algorithm is a direct implementation of the midpoint displacement
algorithm.
It performs the following steps:

\itemize{
 \item{Initialization: }{ Determine the smallest fit of
 \code{max(ncol, nrow)} in \emph{n^2 + 1} and assign value to n.
 Setup matrix of size (n^2 + 1)*(n^2 + 1).
 Afterwards, assign a random value to the four corners of the matrix.}
 \item{Diamond Step: }{ For each square in the matrix, assign the average of
 the four corner points plus a random value to the midpoint of that square.}
 \item{Diamond Step: }{ For each diamond in the matrix, assign the average
  of the four corner points plus a random value to the midpoint of that
  diamond.}
}

At each iteration the roughness, an approximation to common Hurst exponent,
is reduced.
}
\examples{

# simulate midpoint displacement
midpoint_displacememt <- nlm_mpd(ncol = 100,
                                 nrow = 100,
                                 roughness = 0.61)
\dontrun{
# visualize the NLM
rasterVis::levelplot(midpoint_displacememt, margin = FALSE,
par.settings = rasterVis::viridisTheme())
}
}
\references{
\url{https://en.wikipedia.org/wiki/Diamond-square_algorithm}
}
