% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_polylands.R
\name{nlm_polylands}
\alias{nlm_polylands}
\title{nlm_polylands}
\usage{
nlm_polylands(ncol, nrow, resolution = 1, option = 1, germs, g, R,
  patch_classes, rescale = TRUE)
}
\arguments{
\item{ncol}{[\code{numerical(1)}]\cr
Number of columns for the raster.}

\item{nrow}{[\code{numerical(1)}]\cr
Number of rows for the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{option}{[\code{numerical(1)}]\cr
If \code{1} (default), the Tessellation method is used to simulate the NLM.
If \code{2}, the Gibbs algorithm method is used to simulate the NLM.}

\item{germs}{[\code{numerical(1)}]\cr
Intensity parameter (non-negative integer).}

\item{g}{[\code{numerical(1)}]\cr
Interaction parameter (a value between 0 and 1, inclusive - only used when \code{option = 2}).}

\item{R}{[\code{numerical(1)}]\cr
Interaction radius (non-negative integer).}

\item{patch_classes}{[\code{numerical(1)}]\cr
Number of classes for germs.}

\item{rescale}{[\code{logical(1)}]\cr
If \code{TRUE} (default), the values are rescaled between 0-1.
Otherwise, the distance in raster units is calculated.}
}
\value{
RasterLayer
}
\description{
Simulate the NLM introduced in Gaucherel (2008).
}
\details{
The function offers 2 of the 3 NLM described in Gaucherel (2008).
The first one (\code{option = 1}) is a tessellation method.
It generates a random point pattern (the germs) with an independent
distribution and uses the voronoi tessellation to simulate the patchy
landscapes.
The second one (\code{option = 2}) is the Gibbs algorithm method.
The method works in principal like the tessellation method, but instead of
a random point pattern one fits a simulated realization of the Strauss
process. The Strauss process starts with a given number of points and
uses a minimization approach to fit a point pattern with a given interaction
parameter (0 - hardcore process; 1 - poission process) and interaction radius
(distance of points/germs being apart).
}
\examples{
# simulate polygonal landscapes
poly_lands <- nlm_polylands(ncol = 30, nrow = 30, germs = 20)

\dontrun{
# visualize the NLM
util_plot(poly_lands)
}

}
\references{
Gaucherel, C. (2008) Neutral models for polygonal landscapes with linear
networks. \emph{Ecological Modelling}, 219, 39 - 48.
}
