% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pathfinder.R
\name{L2}
\alias{L2}
\title{L2-error}
\usage{
L2(tp, y1, y2, start, stop, index, numSubdivisions = 2000)
}
\arguments{
\item{tp}{A numerical vector of time points (or spatial coordinates along a single axis)}

\item{y1}{A numerical vector of measurements (of the control)}

\item{y2}{A numerical vector of measurements (of the experimental condition)}

\item{start}{A numerical value representing the start time (or spatial coordinate) of the integration}

\item{stop}{A numerical value representing the end time (or spatial coordinate) of the integration}

\item{index}{A vector of positive integers representing the indices of \code{tp} that we subsample}

\item{numSubdivisions}{This can be adjusted to ensure the integration doesn't take too long, especially if we aren't overly concerned with rounding errors.}
}
\value{
A numeric value-- the L2 error.
}
\description{
Given two functions y1(t) and y2(t), this function finds the L2-distance between the following two curves:
a) y1(t)-y2(t) sampled at all time points (\code{tp}) 
b) y1(t)-y2(t) sampled at the time points indexed by \code{index} (\code{tp[index]}).
Note that by setting \code{y2} to \code{rep(0,length(tp))}, this function can be used to estimate the L2-error in the shape of \code{y1}.
}
