% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score-cluster.R
\name{scoreCluster}
\alias{scoreCluster}
\title{Score the clusters in one projection of the bipartite graph.}
\usage{
scoreCluster(community, graph, distance_matrix)
}
\arguments{
\item{community}{An igraph community object.}

\item{graph}{An igraph graph object.}

\item{distance_matrix}{A matrix, the distance of graph, usually got from
\code{\link{findCluster}}}
}
\value{
A list of various scores.
}
\description{
This function will use the community object, graph object and
distance matrix to analyze, mainly using the cluster.stats function in the
fpc package, in addition, it also calculates a ‘coverage’ indicator.
}
\examples{
# load part of the beatAML data
data <- NIMAA::beatAML[1:1000,]
# convert to incidence matrix
inc_mat <- el2IncMatrix(data, print_skim = FALSE)

# run findCluster() to do clustering
cls <- findCluster(
  inc_mat,
  dim = 1,
  method = "infomap",
  normalization = FALSE,
  rm_weak_edges = TRUE,
  comparison = FALSE
)
# get the scoring result
scoreCluster(
  community = cls$infomap,
  graph = cls$graph,
  distance_matrix = cls$distance_matrix
)
}
\seealso{
\code{\link[fpc]{cluster.stats}}, \code{\link{findCluster}}
}
