% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wl_simulator.R
\name{wl_simulator}
\alias{wl_simulator}
\title{Simple simulator to create a waiting list}
\usage{
wl_simulator(
  start_date = NULL,
  end_date = NULL,
  demand = 10,
  capacity = 11,
  waiting_list = NULL,
  withdrawal_prob = NA,
  detailed_sim = FALSE
)
}
\arguments{
\item{start_date}{date. The start date for the simulation.}

\item{end_date}{date. The end date for the simulation.}

\item{demand}{numeric. Weekly demand (i.e., typical referrals per week).}

\item{capacity}{numeric. Weekly capacity (i.e., typical removals per week).}

\item{waiting_list}{integer. The number of patients on the waiting list.}

\item{withdrawal_prob}{numeric. Probability of a patient withdrawing.}

\item{detailed_sim}{logical. If TRUE, simulation provides detailed output.}
}
\value{
data.frame. A df of simulated referrals and removals
}
\description{
Creates a simulated waiting list comprising referral dates,
and removal dates
}
\examples{

over_capacity_simulation <-
  wl_simulator("2024-01-01", "2024-03-31", 100, 110)
under_capacity_simulation <-
  wl_simulator("2024-01-01", "2024-03-31", 100, 90)

}
