% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LOS_model.R
\docType{data}
\name{LOS_model}
\alias{LOS_model}
\title{Hospital Length of Stay (LOS) Data}
\format{Data frame with five columns
\describe{
\item{ID}{A fictional patient ID number}
\item{Organisation}{A factor representing one of ten fictional hospital trusts, e.g. Trust1}
\item{Age}{Age in years of each fictional patient}
\item{LOS}{In-hospital length of stay in days.  The difference between admission and discharge date in dates}
\item{Death}{Binary for death status: 0 = survived, 1= died in hospital}
}}
\source{
Generated by Chris Mainey \email{chris.mainey@uhb.nhs.uk}, Feb-2019
}
\usage{
data(LOS_model)
}
\description{
Artificially generated hospital data. Fictional patients at 10 fictional hospitals, with LOS, Age and Date status data
Data were generate to learn Generalized Linear Models (GLM) concepts, modelling either Death or LOS.
}
\examples{
data(LOS_model)

model1 <- glm(Death ~ Age + LOS, data=LOS_model, family="binomial")
summary(model1)

# Now with an Age, LOS, and Age*LOS interaction.
model2<- glm(Death ~ Age * LOS, data=LOS_model, family="binomial")
summary(model2)

}
\keyword{datasets}
\keyword{hospital}
\keyword{regression}
