% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{updateSpin}
\alias{updateSpin}
\title{Update Spin}
\usage{
updateSpin(NGLVieweR_proxy, spin = TRUE)
}
\arguments{
\item{NGLVieweR_proxy}{A NGLVieweR object.}

\item{spin}{If \code{TRUE} (default), start spinning and stop rocking.}
}
\value{
API call containing \code{NGLVieweR} \code{id} and list of message parameters.
}
\description{
Start spin animation and stop rocking. Works on an existing NGLVieweR object in Shinymode.
}
\examples{
\dontrun{
NGLVieweR_proxy("structure") \%>\% updateRock(TRUE)
}
if (interactive()) {
library(shiny)

ui = fluidPage(
  titlePanel("Viewer with API inputs"),
  sidebarLayout(
    sidebarPanel(
      radioButtons("animate", label = "Animation",
                   choices = c("None", "Spin", "Rock"), selected = "None")
    ),
    mainPanel(
      NGLVieweROutput("structure")
    )
  )
)
server = function(input, output) {
  output$structure <- renderNGLVieweR({
    NGLVieweR("7CID") \%>\%
      addRepresentation("cartoon", 
      param = list(name = "cartoon", color="red"))
  })

  observeEvent(input$animate,{
    if(input$animate == "Rock"){
      NGLVieweR_proxy("structure") \%>\%
       updateRock(TRUE)
    } else if(input$animate == "Spin") {
      NGLVieweR_proxy("structure") \%>\%
       updateSpin(TRUE)
    } else{
      NGLVieweR_proxy("structure") \%>\%
       updateRock(FALSE) \%>\%
       updateSpin(FALSE)
    }
  })
 }
shinyApp(ui, server)
}
}
\seealso{
\itemize{
\item \code{\link[=setSpin]{setSpin()}}
\item \code{\link[=NGLVieweR_example]{NGLVieweR_example()}} See example "updateAnimation".
}

Other animations: 
\code{\link{setRock}()},
\code{\link{setSpin}()},
\code{\link{updateRock}()},
\code{\link{updateZoomMove}()},
\code{\link{zoomMove}()}
}
\concept{animations}
