% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference_data_selection.R
\name{select_daily_reference_data}
\alias{select_daily_reference_data}
\title{select_daily_reference_data}
\usage{
select_daily_reference_data(standard_df, analyte, min_nobs = NA)
}
\arguments{
\item{standard_df}{Input reference data.frame.}

\item{analyte}{Are we calibrating CO2 and H2O?
(Use argument 'co2' or 'h2o', or else function will throw error)}

\item{min_nobs}{Minimum number of high-frequency
observations to define a peak. If not supplied,
defaults are 200 for \code{analyte = 'co2'} or 30 for
\code{analyte = 'h2o'}}
}
\value{
Smaller data.frame where only the reference data selected
to use in the calibration routines is returned. Assumes that we are
calibrating on a daily basis, and not on a longer time scale. Data
are selected based on two criteria: cannot be missing, and must be
at least a certain number of high-frequency observations in order to
qualify as a valid measurement. For the water system, this function
also keeps only the last three injections for each reference water
per day.
}
\description{
select_daily_reference_data
}
