MergeSNPsGenes <-
function(snpdf,genedf,quiet=FALSE,markercolumn="marker")
   {
   if(missing(snpdf))
     stop("No dataframe provided with the snps (generated by GetSNPInfo)")
   if(missing(genedf))
     stop("No dataframe provided with the genes (generated by GetGeneInfo)")
   if(class(snpdf)!="data.frame")
     stop("The snp information provided is not as a data.frame. This function requires the information returned from GetSNPInfo")
   if(class(genedf)!="data.frame")
     stop("The gene information provided is not as a data.frame. This function requires the information returned from GetGeneInfo")
   snpdf<-SplitGenes(snpdf,quiet)  
   snpdf$oso<-1:nrow(snpdf) 
   genedf$chr<-NULL 
   snps.genes<-merge(snpdf,genedf,by.x="locusID",by.y="locusID",all.x=TRUE,all.y=TRUE)
   snps.genes$genesymbol.x<-NULL         
   snps.genes$genesymbol<-snps.genes$genesymbol.y
   snps.genes$genesymbol.y<-NULL                 
   snps.genes<-clean.NAs(snps.genes)     

   snps.genes<-move.column(snps.genes,markercolumn,1)
   snps.genes<-move.column(snps.genes,"genesymbol",5)
   snps.genes<-move.column(snps.genes,"genename",6)
   snps.genes<-move.column(snps.genes,"locusID",4)
   snps.genes<-move.column(snps.genes,"fxn_class",4)   
   snps.genes<-snps.genes[order(snps.genes$oso),]
   snps.genes$oso<-NULL
   return(newdf=snps.genes)
   print("end of MergeSNPsGenes")
   }
   