/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.recommender.TopItems;
import org.apache.mahout.cf.taste.impl.similarity.GenericUserSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.apache.mahout.common.RandomUtils;

public final class GenericItemSimilarity
implements ItemSimilarity {
    private static final long[] NO_IDS = new long[0];
    private final FastByIDMap<FastByIDMap<Double>> similarityMaps = new FastByIDMap();
    private final FastByIDMap<FastIDSet> similarItemIDsIndex = new FastByIDMap();

    public GenericItemSimilarity(Iterable<ItemItemSimilarity> similarities) {
        this.initSimilarityMaps(similarities.iterator());
    }

    public GenericItemSimilarity(Iterable<ItemItemSimilarity> similarities, int maxToKeep) {
        List<ItemItemSimilarity> keptSimilarities = TopItems.getTopItemItemSimilarities(maxToKeep, similarities.iterator());
        this.initSimilarityMaps(keptSimilarities.iterator());
    }

    public GenericItemSimilarity(ItemSimilarity otherSimilarity, DataModel dataModel) throws TasteException {
        long[] itemIDs = GenericUserSimilarity.longIteratorToList(dataModel.getItemIDs());
        this.initSimilarityMaps(new DataModelSimilaritiesIterator(otherSimilarity, itemIDs));
    }

    public GenericItemSimilarity(ItemSimilarity otherSimilarity, DataModel dataModel, int maxToKeep) throws TasteException {
        long[] itemIDs = GenericUserSimilarity.longIteratorToList(dataModel.getItemIDs());
        DataModelSimilaritiesIterator it = new DataModelSimilaritiesIterator(otherSimilarity, itemIDs);
        List<ItemItemSimilarity> keptSimilarities = TopItems.getTopItemItemSimilarities(maxToKeep, it);
        this.initSimilarityMaps(keptSimilarities.iterator());
    }

    private void initSimilarityMaps(Iterator<ItemItemSimilarity> similarities) {
        while (similarities.hasNext()) {
            long itemID2;
            long itemID1;
            long similarityItemID2;
            ItemItemSimilarity iic = similarities.next();
            long similarityItemID1 = iic.getItemID1();
            if (similarityItemID1 == (similarityItemID2 = iic.getItemID2())) continue;
            if (similarityItemID1 < similarityItemID2) {
                itemID1 = similarityItemID1;
                itemID2 = similarityItemID2;
            } else {
                itemID1 = similarityItemID2;
                itemID2 = similarityItemID1;
            }
            FastByIDMap<Double> map = this.similarityMaps.get(itemID1);
            if (map == null) {
                map = new FastByIDMap();
                this.similarityMaps.put(itemID1, map);
            }
            map.put(itemID2, iic.getValue());
            this.doIndex(itemID1, itemID2);
            this.doIndex(itemID2, itemID1);
        }
    }

    private void doIndex(long fromItemID, long toItemID) {
        FastIDSet similarItemIDs = this.similarItemIDsIndex.get(fromItemID);
        if (similarItemIDs == null) {
            similarItemIDs = new FastIDSet();
            this.similarItemIDsIndex.put(fromItemID, similarItemIDs);
        }
        similarItemIDs.add(toItemID);
    }

    @Override
    public double itemSimilarity(long itemID1, long itemID2) {
        long secondID;
        long firstID;
        if (itemID1 == itemID2) {
            return 1.0;
        }
        if (itemID1 < itemID2) {
            firstID = itemID1;
            secondID = itemID2;
        } else {
            firstID = itemID2;
            secondID = itemID1;
        }
        FastByIDMap<Double> nextMap = this.similarityMaps.get(firstID);
        if (nextMap == null) {
            return Double.NaN;
        }
        Double similarity = nextMap.get(secondID);
        return similarity == null ? Double.NaN : similarity;
    }

    @Override
    public double[] itemSimilarities(long itemID1, long[] itemID2s) {
        int length = itemID2s.length;
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.itemSimilarity(itemID1, itemID2s[i]);
        }
        return result;
    }

    @Override
    public long[] allSimilarItemIDs(long itemID) {
        FastIDSet similarItemIDs = this.similarItemIDsIndex.get(itemID);
        return similarItemIDs != null ? similarItemIDs.toArray() : NO_IDS;
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
    }

    private static final class DataModelSimilaritiesIterator
    extends AbstractIterator<ItemItemSimilarity> {
        private final ItemSimilarity otherSimilarity;
        private final long[] itemIDs;
        private int i;
        private long itemID1;
        private int j;

        private DataModelSimilaritiesIterator(ItemSimilarity otherSimilarity, long[] itemIDs) {
            this.otherSimilarity = otherSimilarity;
            this.itemIDs = itemIDs;
            this.i = 0;
            this.itemID1 = itemIDs[0];
            this.j = 1;
        }

        @Override
        protected ItemItemSimilarity computeNext() {
            int size = this.itemIDs.length;
            ItemItemSimilarity result = null;
            while (result == null && this.i < size - 1) {
                double similarity;
                long itemID2 = this.itemIDs[this.j];
                try {
                    similarity = this.otherSimilarity.itemSimilarity(this.itemID1, itemID2);
                }
                catch (TasteException te) {
                    throw new IllegalStateException(te);
                }
                if (!Double.isNaN(similarity)) {
                    result = new ItemItemSimilarity(this.itemID1, itemID2, similarity);
                }
                if (++this.j != size) continue;
                this.itemID1 = this.itemIDs[++this.i];
                this.j = this.i + 1;
            }
            if (result == null) {
                return (ItemItemSimilarity)this.endOfData();
            }
            return result;
        }
    }

    public static final class ItemItemSimilarity
    implements Comparable<ItemItemSimilarity> {
        private final long itemID1;
        private final long itemID2;
        private final double value;

        public ItemItemSimilarity(long itemID1, long itemID2, double value) {
            Preconditions.checkArgument(value >= -1.0 && value <= 1.0, "Illegal value: %s", value);
            this.itemID1 = itemID1;
            this.itemID2 = itemID2;
            this.value = value;
        }

        public long getItemID1() {
            return this.itemID1;
        }

        public long getItemID2() {
            return this.itemID2;
        }

        public double getValue() {
            return this.value;
        }

        public String toString() {
            return "ItemItemSimilarity[" + this.itemID1 + ',' + this.itemID2 + ':' + this.value + ']';
        }

        @Override
        public int compareTo(ItemItemSimilarity other) {
            double otherValue = other.getValue();
            return this.value > otherValue ? -1 : (this.value < otherValue ? 1 : 0);
        }

        public boolean equals(Object other) {
            if (!(other instanceof ItemItemSimilarity)) {
                return false;
            }
            ItemItemSimilarity otherSimilarity = (ItemItemSimilarity)other;
            return otherSimilarity.getItemID1() == this.itemID1 && otherSimilarity.getItemID2() == this.itemID2 && otherSimilarity.getValue() == this.value;
        }

        public int hashCode() {
            return (int)this.itemID1 ^ (int)this.itemID2 ^ RandomUtils.hashDouble((double)this.value);
        }
    }
}

