/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.base.Preconditions;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.recommender.AbstractCandidateItemsStrategy;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;

public class AllSimilarItemsCandidateItemsStrategy
extends AbstractCandidateItemsStrategy {
    private final ItemSimilarity similarity;

    public AllSimilarItemsCandidateItemsStrategy(ItemSimilarity similarity) {
        Preconditions.checkArgument(similarity != null, "similarity is null");
        this.similarity = similarity;
    }

    @Override
    FastIDSet doGetCandidateItems(long[] preferredItemIDs, DataModel dataModel) throws TasteException {
        FastIDSet candidateItemIDs = new FastIDSet();
        for (long itemID : preferredItemIDs) {
            candidateItemIDs.addAll(this.similarity.allSimilarItemIDs(itemID));
        }
        candidateItemIDs.removeAll(preferredItemIDs);
        return candidateItemIDs;
    }
}

