% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MANOVA.R
\name{MANOVA}
\alias{MANOVA}
\title{Analise de variancia multivariada}
\usage{
MANOVA(Dados,Modelo)
}
\arguments{
\item{Dados}{Matriz contendo os dados para execucao da MANOVA. Para cada
modelo o conjunto de dados precisa estar organizado de uma forma apropriada:
\itemize{ \item Modelos 1 e 2: As duas primeiras colunas devem conter a
identificacao dos tratamentos e repeticoes/blocos, e as demais os valores
observanos nas variaveis respostas. \item Modelo 3: As tres primeiras
colunas devem conter as informacoes dos tratamentos, linhas e colunas, e
posteriormente, os valores da variavel resposta. \item Modelos 4 e 5: as
primeiras colunas precisam ter a informacao do fator A, fator B,
repeticao/bloco, e posteriormente, as variaveis respostas.
 \item Modelos 6 e 7: as primeiras colunas precisam ter a
 informacao do fator A, fator B, fator C, repeticao/bloco, e posteriormente, as
 variaveis respostas.}}

\item{Modelo}{Valor numerico indicando o delineamento: \itemize{ \item 1 =
Delineamento inteiramente casualizado (DIC) \item 2 = Delineamento em blocos
casualizados (DBC) \item 3 = Delineamento em quadrado latino (DQL) \item 4 =
Esquema fatorial duplo em DIC \item 5 = Esquema fatorial duplo em DBC
\item 6 =
Esquema fatorial triplo em DIC \item 7 = Esquema fatorial triplo em DBC }}
}
\value{
A funcao retorna a MANOVA, a matriz de (co)variancia residual e o
 numero dos graus de liberdade do residuo.
}
\description{
Esta funcao retorna o resultado da analise de variancia
 multivariada (MANOVA).
}
\examples{
\donttest{
#Delineamento inteiramente casualizado (DIC)
data("Dados.DIC")
MANOVA(Dados.DIC,1)

#Delineamento em blocos casualizados (DBC)
data(Dados.DBC)
MANOVA(Dados.DBC,2)

#Delineamento em quadrado latino (DQL)
data(Dados.DQL)
MANOVA(Dados.DQL,3)

#Esquema fatorial duplo em DIC
data(Dados.Fat2.DIC)
MANOVA(Dados.Fat2.DIC,4)

#Esquema fatorial duplo em DBC
data(Dados.Fat2.DBC)
MANOVA(Dados.Fat2.DBC,5)

#' #Esquema fatorial triplo em DIC
data(Dados.Fat3.DIC)
MANOVA(Dados.Fat3.DIC,6)

#Esquema fatorial triplo em DBC
data(Dados.Fat3.DBC)
MANOVA(Dados.Fat3.DBC,7)
}
}
\references{
PlayList "Curso de Analise Multivariada":
 https://www.youtube.com/playlist?list=PLvth1ZcREyK72M3lFl7kBaHiVh5W53mlR


CRUZ, C.D. and CARNEIRO, P.C.S.  Modelos biometricos aplicados ao
  melhoramento genetico. 3nd Edition. Vicosa, UFV, v.2, 2014. 668p.  (ISBN: 8572691510)

FERREIRA, D.F. Estatistica Multivariada. (2018) 3ed. UFLA. 624p. (ISBN 13:978 8581270630)

 HAIR, J.F. Multivariate Data Analysis.  (2016) 6ed. Pearson Prentice HalL.
  (ISBN 13:978 0138132637)
}
\seealso{
\code{\link{lm}}, \code{\link{manova}}
}
