% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SADF.R
\name{sadf}
\alias{sadf}
\title{Critical values for sup ADF statistic sequence.}
\usage{
sadf(m, t)
}
\arguments{
\item{m}{Number of Monte Carlo Simulations. Default equals 2000. Must be bigger than 2.}

\item{t}{Sample size. Default equals 100. Must be bigger than 2.}
}
\description{
Calculate critical value sequences for the sup ADF statistic sequence using
 Monte Carlo simulations for a sample generated from a Normal distribution.
}
\examples{
foo <- sadf(m = 20, t = 50)
quant <- rep(foo$quantiles[2], 100)
plot(quant, type = 'l')
}
\references{
Phillips, P.C. & Shi, S. & Yu, J. (2015a). "Testing for Multiple Bubbles: Historical Episodes of Exuberance and Collapse in the S&P 500". \emph{SSRN Electronic Journal}.
}
\keyword{AugmentedDickey-FullerTest,}
\keyword{MonteCarlo.}
\keyword{supADFSequence}
