% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partitions.r
\name{Partition_2Perm}
\alias{Partition_2Perm}
\title{Permutation of elements according to partition pU}
\usage{
Partition_2Perm(pU)
}
\arguments{
\item{pU}{A partition matrix. For instance a matrix generated by Partition_Type_All.}
}
\value{
\code{perm_pU} A vector with the elements \code{1} to \code{N} permuted according to \code{pU}.
The numbers of 1 : N are listed in the order of their occurrence in the blocks of \code{pU}.
}
\description{
Permutation of elements according to partition pU
}
\examples{
PA<-Partition_Type_All(4)
Partition_2Perm(PA$Part.class[[3]])

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section 1.4.4
}
\seealso{
Other Partitions: 
\code{\link{Partition_Indecomposable}()},
\code{\link{Partition_Pairs}()},
\code{\link{Partition_Type_All}()},
\code{\link{Permutation_Inverse}()}
}
\concept{Partitions}
