% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotTree}
\alias{plotTree}
\title{Plot MrSGUIDE regression tree}
\usage{
plotTree(
  mrsobj,
  digits = 3,
  height = "600px",
  width = "100\%",
  nodefontSize = 16,
  edgefontSize = 14,
  minNodeSize = 15,
  maxNodeSize = 30,
  nodeFixed = FALSE,
  edgeColor = "#8181F7",
  highlightNearest = list(enabled = TRUE, degree = list(from = 50000, to = 0), hover =
    FALSE, algorithm = "hierarchical"),
  collapse = list(enabled = FALSE, fit = TRUE, resetHighlight = TRUE, clusterOptions =
    list(fixed = TRUE, physics = FALSE)),
  alphaInd = 3
)
}
\arguments{
\item{mrsobj}{MrSGUIDE object}

\item{digits}{digits for split threshold}

\item{height}{figure height}

\item{width}{figure width}

\item{nodefontSize}{node font size}

\item{edgefontSize}{edge font size}

\item{minNodeSize}{minimal node size}

\item{maxNodeSize}{maximum node size}

\item{nodeFixed}{whether you can drag node}

\item{edgeColor}{edge color}

\item{highlightNearest}{choose node will highlight nearby}

\item{collapse}{list, collapse or not using double click on a node}

\item{alphaInd}{1 is original alpha, 2 is individual level alpha, 3 is overall alpha}
}
\value{
A list contains plot figure
\item{treeplot}{The tree plot uses \code{\link[visNetwork]{visNetwork}} function.}
\item{nodeTreat}{A data frame contain each elements used for tree plot.}
\item{trtPlot}{A treatment effects plot of each node.}
}
\description{
Plot MrSGUIDE regression tree
}
\examples{
library(MrSGUIDE)
set.seed(1234)

N = 200
np = 3

numX <- matrix(rnorm(N * np), N, np) ## numerical features
gender <- sample(c('Male', 'Female'), N, replace = TRUE)
country <- sample(c('US', 'UK', 'China', 'Japan'), N, replace = TRUE)

z <- sample(c(0, 1), N, replace = TRUE) # Binary treatment assignment

y1 <- numX[, 1] + 1 * z * (gender == 'Female') + rnorm(N)
y2 <- numX[, 2] + 2 * z * (gender == 'Female') + rnorm(N)

train <- data.frame(numX, gender, country, z, y1, y2)
role <- c(rep('n', 3), 'c', 'c', 'r', 'd', 'd')

mrsobj <- MrSFit(dataframe = train, role = role)
plotObj <- plotTree(mrsobj)
#plotObj$treePlot
plotObj$nodeTreat ## node information
plotObj$trtPlot ## treatment effect plot

}
