% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortalityTable.Weibull.R
\docType{class}
\name{mortalityTable.Weibull-class}
\alias{mortalityTable.Weibull-class}
\alias{mortalityTable.Weibull}
\title{Class mortalityTable.Weibull - Mortality table with Weibull's law}
\description{
A period life table following Weibulls's law of a mortality rate
\eqn{\mu} increasing as a power of \eqn{t}: \deqn{\mu_{x+t} = k * (x+t)^n}
The only required slots are the parameters \eqn{k>0} and \eqn{n>0}, all probabilities
are calculated from them, for technical reasons a maximum age of 150 is
technically assumed.  Optionally, a name and loading can be passed
(inherited from \code{\link{mortalityTable}}).
}
\section{Slots}{

\describe{
\item{\code{k}}{Parameter k of the Weibull distribution}

\item{\code{n}}{Parameter n of the Weibull distribution}

\item{\code{omega}}{Maximum age (default: 120)}
}}

\examples{
# A Weibull mortality
wbl = mortalityTable.Weibull(k = 0.0000000001, n = 4.8)
mortalityTables.load("Austria_Annuities_AVOe2005R")
plot(wbl, AVOe2005R.male, Period=2017, ylim = c(0.00005, 1))

}
