% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.normals.r
\name{plotNormals}
\alias{plotNormals}
\title{plots the normals of a triangular surface mesh.}
\usage{
plotNormals(x, length = 1, lwd = 1, col = 1, ...)
}
\arguments{
\item{x}{object of class "mesh3d"}

\item{length}{either a single numeric value or a numeric vector defining per-normals lenght (default is 1)}

\item{lwd}{width of the normals}

\item{col}{color of the normals}

\item{...}{addtional parameters, currently not in use.}
}
\description{
visualises the vertex normals of a triangular surface mesh of class mesh3d.
If no normals are contained, they are computed.
}
\examples{

\dontrun{
require(rgl)
data(nose)
plotNormals(shortnose.mesh,col=4,long=0.01)
shade3d(shortnose.mesh,col=3)
}

}
\author{
Stefan Schlager
}
