% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetrize.r
\name{symmetrize}
\alias{symmetrize}
\title{create a perfectly symmetric version of landmarks}
\usage{
symmetrize(x, pairedLM)
}
\arguments{
\item{x}{k x m matrix with rows containing landmark coordinates}

\item{pairedLM}{A X x 2 matrix containing the indices (rownumbers) of the
paired LM. E.g. the left column contains the lefthand landmarks, while the
right side contains the corresponding right hand landmarks.}
}
\value{
a symmetrized version of \code{x}
}
\description{
create a perfectly symmetric version of landmarks
}
\details{
the landmarks are reflected and relabled according to
\code{pairedLM} and then rotated and translated onto \code{x}.
Both configurations are then averaged to obtain a perfectly symmetric one.
}
\examples{
data(boneData)
left <- c(4,6,8)
right <- c(3,5,7)
pairedLM <- cbind(left,right)
symx <- symmetrize(boneLM[,,2],pairedLM)
\dontrun{
deformGrid3d(symx,boneLM[,,2])
}
}
\references{
Klingenberg CP, Barluenga M, and Meyer A. 2002. Shape analysis of symmetric
structures: quantifying variation among individuals and asymmetry. Evolution
56(10):1909-1920.
}

