% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-shapedescriptors.R
\name{coo_eccentricity}
\alias{coo_eccentricity}
\alias{coo_eccentricityeigen}
\alias{coo_eccentricityeigen.default}
\alias{coo_eccentricityeigen.Coo}
\alias{coo_eccentricityboundingbox}
\alias{coo_eccentricityboundingbox.default}
\alias{coo_eccentricityboundingbox.Coo}
\title{Calculates the eccentricity of a shape}
\source{
Rosin PL. 2005. Computing global shape measures.
Handbook of Pattern Recognition and Computer Vision. 177-196.
}
\usage{
coo_eccentricityeigen(coo)

\method{coo_eccentricityeigen}{default}(coo)

\method{coo_eccentricityeigen}{Coo}(coo)

coo_eccentricityboundingbox(coo)

\method{coo_eccentricityboundingbox}{default}(coo)

\method{coo_eccentricityboundingbox}{Coo}(coo)
}
\arguments{
\item{coo}{a \code{matrix} of (x; y) coordinates or any \code{Coo}}
}
\value{
\code{numeric} for single shapes, \code{list} for \code{Coo}.
}
\description{
\code{coo_eccentricityeigen} uses the ratio of
the eigen values (inertia axes of coordinates).
\code{coo_eccentricityboundingbox} uses the width/length ratio (see \link{coo_lw}).
}
\examples{
# coo_eccentricityeigen
bot[1] \%>\% coo_eccentricityeigen()
bot \%>\%
    slice(1:3) \%>\% # for speed sake only
    coo_eccentricityeigen()

# coo_eccentricityboundingbox
bot[1] \%>\% coo_eccentricityboundingbox()
bot \%>\%
    slice(1:3) \%>\% # for speed sake only
    coo_eccentricityboundingbox()
}
\seealso{
\link{coo_eccentricityboundingbox}

Other coo_ descriptors: 
\code{\link{coo_angle_edges}()},
\code{\link{coo_angle_tangent}()},
\code{\link{coo_area}()},
\code{\link{coo_boundingbox}()},
\code{\link{coo_chull}()},
\code{\link{coo_circularity}()},
\code{\link{coo_convexity}()},
\code{\link{coo_elongation}()},
\code{\link{coo_length}()},
\code{\link{coo_lw}()},
\code{\link{coo_rectangularity}()},
\code{\link{coo_rectilinearity}()},
\code{\link{coo_scalars}()},
\code{\link{coo_solidity}()},
\code{\link{coo_tac}()},
\code{\link{coo_width}()}
}
\concept{coo_ descriptors}
