% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-out-tfourier.R
\name{tfourier}
\alias{tfourier}
\alias{tfourier.default}
\alias{tfourier.Out}
\title{Tangent angle Fourier transform}
\usage{
tfourier(x, ...)

\method{tfourier}{default}(x, nb.h, smooth.it = 0, norm = FALSE,
  verbose = TRUE, ...)

\method{tfourier}{Out}(x, nb.h = 40, smooth.it = 0, norm = TRUE,
  verbose = TRUE, ...)
}
\arguments{
\item{x}{A list or matrix of coordinates or an \code{Out}}

\item{...}{useless here}

\item{nb.h}{\code{integer}. The number of harmonics to use. If missing, 12 is used on shapes;
99 percent of harmonic power on Out objects, both with messages.}

\item{smooth.it}{\code{integer}. The number of smoothing iterations to
perform}

\item{norm}{\code{logical}. Whether to scale and register new coordinates so
that the first point used is sent on the origin.}

\item{verbose}{\code{logical}. Whether to display diagnosis messages.}
}
\value{
A list with the following components:
\itemize{
\item \code{ao} ao harmonic coefficient
\item \code{an} vector of \eqn{a_{1->n}} harmonic coefficients
\item \code{bn} vector of \eqn{b_{1->n}} harmonic coefficients
\item \code{phi} vector of variation of the tangent angle
\item \code{t} vector of distance along the perimeter expressed in radians
\item \code{perimeter} numeric. The perimeter of the outline
\item \code{thetao} numeric. The first tangent angle
\item \code{x1} The x-coordinate of the first point
\item \code{y1} The y-coordinate of the first point.
}
}
\description{
\code{tfourier} computes tangent angle Fourier analysis from a matrix or a
list of coordinates.
}
\note{
Directly borrowed for Claude (2008), and called \code{fourier2} there.
}
\examples{
data(bot)
coo <- bot[1]
coo_plot(coo)
tf  <- tfourier(coo, 12)
tf
tfi <- tfourier_i(tf)
coo_draw(tfi, border='red', col=NA) # the outline is not closed...
coo_draw(tfourier_i(tf, force2close=TRUE), border='blue', col=NA) # we force it to close.
}
\references{
Zahn CT, Roskies RZ. 1972. Fourier Descriptors for Plane Closed
Curves. \emph{IEEE Transactions on Computers} \bold{C-21}: 269-281.

Claude, J. (2008) \emph{Morphometrics with R}, Use R! series, Springer 316
pp.
}
\seealso{
Other tfourier: \code{\link{tfourier_i}},
  \code{\link{tfourier_shape}}
}
