% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babel-export.R
\name{export}
\alias{export}
\title{Exports Coe objects and shapes}
\usage{
export(x, file, sep, dec)
}
\arguments{
\item{x}{a Coe object}

\item{file}{the filenames \code{data.txt} by default}

\item{sep}{the field separator string (see \code{sep} in \link{write.table}). A
tab by default}

\item{dec}{the string to use for decimal points (see \code{dec} in \link{write.table}). A dot
by default.}
}
\description{
Writes a \code{.txt} or \code{.xls} or whatever readable from a \link{Coe}, or PCA
object, along with individual names and grouping factors. A simple wrapper
around \link{write.table}.
}
\note{
Default parameters will write a \code{.txt} file, directly readable by MS Excel
and other programs. With default parameters, numbers will dots as decimal points, which is
considered as a character chain in Excel in many countries (locale versions.) this can be solved
using \code{dec=','} as in the examples below.

If you are new to R, you may be looking for where this damn file has been saved. With the defaults
settings, \code{getwd()} will provide the answer.

I have to mention that everytime you use this function, escape from R to use Excel and
do 'statistics' there, an adorable kitten is probably murdered somewhere. Use R, not Excel!
}
\examples{
\dontrun{
# Will write files on your machine!
data(bot)
bot.f <- efourier(bot, 6)
export(bot.f) # data.txt which can be opened by every software including MS Excel
# If you are French, or another country that has not been invaded by anglo-american rules.
# and for use in Excel.
export(bot.f, dec=',')
export(bot.f, file='data.xls', dec=',')

# for shapes (matrices)
 export(bot[1], file='bot1.txt')
}
}
\seealso{
babel functions
}
