% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-MANOVA.R
\name{MANOVA_PW}
\alias{MANOVA_PW}
\alias{MANOVA_PW.PCA}
\title{Pairwise Multivariate analyses of variance}
\usage{
MANOVA_PW(x, ...)

\method{MANOVA_PW}{PCA}(x, fac, verbose = FALSE, retain = 0.99, ...)
}
\arguments{
\item{x}{a \link{PCA} object}

\item{...}{more arguments to feed \link{MANOVA}}

\item{fac}{a name (or its id) of a grouping factor in \code{$fac} or a factor or a formula.}

\item{verbose}{to feed \link{MANOVA}}

\item{retain}{the number of PC axis to retain (1:retain) or the proportion of variance to capture (0.99 par default).}
}
\value{
a list with the following components is returned (invisibly because $manovas
may be very long, see examples):
\itemize{
 \item manovas a list containing all the raw manovas
 \item summary a matrix with all important statists
 \item stars.tab a table with 'significance star', discutable but useful:
 '***' if Pr(>F) < 0.001; '**' of < 0.01; '*' if < 0.05; '.' if < 0.10 and '-' if above.
}
}
\description{
A wrapper for pairwise \link{MANOVA}s on \link{Coe} objects. Calculates a MANOVA for every
pairwise combination of the factor provided.
}
\note{
Needs a review and should be considered as experimental.
If the fac passed has only two levels, there is only pair and it is
equivalent to \link{MANOVA}. \code{MANOVA_PW.PCA} works with the regular \link{manova}.
}
\examples{
data(bot)
# we create a fake factor with 4 levels
bot$fac$fake <- factor(rep(letters[1:4], each=10))
bot.p <- PCA(efourier(bot, 8))
MANOVA_PW(bot.p, 'fake') # or MANOVA_PW(bot.p, 2)

# an example on open outlines
data(olea)
op <- PCA(npoly(olea))
MANOVA_PW(op, 'domes')
# to get the results
res <- MANOVA_PW(op, 'domes')
res$manovas
res$stars.tab
res$summary
}
\seealso{
\link{MANOVA}, \link{manova}.

Other multivariate: \code{\link{CLUST}},
  \code{\link{KMEANS}}, \code{\link{LDA}},
  \code{\link{MANOVA}}, \code{\link{PCA}},
  \code{\link{classification_metrics}}
}
