% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-LDA.R
\name{reLDA}
\alias{reLDA}
\alias{reLDA.Coe}
\alias{reLDA.PCA}
\alias{reLDA.default}
\title{"Redo" a LDA on new data}
\usage{
reLDA(newdata, LDA)

\method{reLDA}{default}(newdata, LDA)

\method{reLDA}{PCA}(newdata, LDA)

\method{reLDA}{Coe}(newdata, LDA)
}
\arguments{
\item{newdata}{to use, a \link{PCA} or any \link{Coe} object}

\item{LDA}{a \link{LDA} object}
}
\value{
a list with components (from ?predict.lda ).
\itemize{
\item class factor of classification
\item posterior posterior probabilities for the classes
\item x the scores of test cases
\item res data.frame of the results
\item CV.tab a confusion matrix of the results
\item CV.correct proportion of the diagonal of CV.tab
\item newdata the data used to calculate passed to predict.lda
}
}
\description{
Basically a wrapper around \link{predict.lda} from the package MASS. Uses a LDA model
to classify new data.
}
\note{
Uses the same number of PC axis as the LDA object provided. You should probably use \link{rePCA} in
conjonction with reLDA to get 'homologous' scores.
}
\examples{
data(bot)
# We select the first 10 individuals in bot,
# for whisky and beer bottles. It will be our referential.
bot1   <- slice(bot, c(1:10, 21:30))
# Same thing for the other 10 individuals.
# It will be our unknown dataset on which we want
# to calculate classes.
bot2   <- slice(bot, c(11:20, 31:40))

# We calculate efourier on these two datasets
bot1.f <- efourier(bot1, 8)
bot2.f <- efourier(bot2, 8)

# Here we obtain our LDA model: first, a PCA, then a LDA
bot1.p <- PCA(bot1.f)
bot1.l <- LDA(bot1.p, "type")

# we redo the same PCA since we worked with scores
bot2.p <- rePCA(bot1.p, bot2.f)

# we finally "predict" with the model obtained before
bot2.l <- reLDA(bot2.p, bot1.l)
bot2.l

}

