% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindowsSetup.R
\name{SetupWindowsTrigger}
\alias{SetupWindowsTrigger}
\title{Setup MobileTrigger Folder Structure and Files}
\usage{
SetupWindowsTrigger(path = NULL, SMTP.Settings, Mail.To, Mail.From)
}
\arguments{
\item{path}{string, top level folder called the [TriggerPath]}

\item{SMTP.Settings}{list, list of smtp.setting to send to mailR::mail.send.
See examples below for outlook and other styles of smtp setting
might be specified}

\item{Mail.To}{string, e-mail address you want MobileTriggers to respond to}

\item{Mail.From}{string, e-mail address you want MobileTriggers to use to send.}
}
\value{
Sets up a folder and file structure at the [TriggerPath].
}
\description{
This is the heart of the MobileTrigger package. You specify where you
want your tigger folder to be and some e-mail information and this This function
builds all the scripts you need to get started. At this time,
the function works ONLY for windows users.
}
\examples{
\donttest{
#################################
# Setting of MobileTriggers     #
#################################

## OUTLOOK Style (uses tls = TRUE argument) ###
  SetupWindowsTrigger(path="c:/triggers",
                      Mail.To = "Your.Email@mobile.com",
                      Mail.From = "someuser@outlook.com",
                      SMTP.Settings=list(
                          host.name = 'smtp.office365.com',
                          port = 587,
                          user.name = 'someuser@outlook.com',
                          passwd = 'password', tls = TRUE)
  )

## Other STYLE (uses ssl = TRUE argument) ###
  SetupWindowsTrigger(path="c:/triggers",
                      Mail.To = "Your.Email@mobile.com",
                      Mail.From = "R.Triggers@desktop.com",
                      SMTP.Settings=list(
                          host.name = 'some.smtp.sever.com',
                          port = 587,
                          user.name = 'R.Triggers@desktop.com',
                          passwd = 'password', ssl = TRUE)
  )
}
}
