% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/motbf.R
\name{plot.motbf}
\alias{plot.motbf}
\title{Plots for \code{'motbf'} Objects}
\usage{
\method{plot}{motbf}(x, xlim = 0:1, ylim = NULL, type = "l", ...)
}
\arguments{
\item{x}{An object of class \code{'motbf'}.}

\item{xlim}{The range to be encompassed by the x axis; by default \code{0:1}.}

\item{ylim}{The range}

\item{type}{As for \link{plot}.}

\item{\dots}{Further arguments to be passed as for \link{plot}.}
}
\value{
A plot of the specificated function.
}
\description{
Draws an \code{'motbf'} function.
}
\examples{
## 1. EXAMPLE
## Data
X <- rexp(2000)

## Learning
f1 <- univMoTBF(X, POTENTIAL_TYPE = "MOP"); f1
f2 <- univMoTBF(X, POTENTIAL_TYPE = "MTE", maxParam = 10); f2
f3 <- univMoTBF(X, POTENTIAL_TYPE = "MOP", nparam=10); f3
## Plots
plot(NULL, xlim = range(X), ylim = c(0,0.8), xlab="X", ylab="density")
plot(f1, xlim = range(X), col = 1, add = TRUE)
plot(f2, xlim = range(X), col = 2, add = TRUE)
plot(f3, xlim = range(X), col = 3, add = TRUE)
hist(X, prob = TRUE, add= TRUE)

## 2. EXAMPLE
## Data
X <- c(rnorm(2000, mean = -3),rnorm(2000, mean = 3))

## Learning
f1 <- univMoTBF(X, POTENTIAL_TYPE = "MOP"); f1
f2 <- univMoTBF(X, POTENTIAL_TYPE = "MTE"); f2
## Plots
plot(NULL, xlim = range(X), ylim = c(0,0.20), xlab="X", ylab="density")
plot(f1, xlim = range(X), col = 2, add = TRUE)
plot(f2, xlim = range(X), col = 4, add = TRUE)
hist(X, prob = TRUE, add= TRUE)
}

