% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_auxiliaryFunctions.R
\name{scoreTest}
\alias{scoreTest}
\alias{print.scoretest.monan}
\title{scoreTest}
\usage{
scoreTest(ans, effects)

\method{print}{scoretest.monan}(x, ...)
}
\arguments{
\item{ans}{An object of class "result.monan" resulting from an estimation with the function \code{\link[=estimateMobilityNetwork]{estimateMobilityNetwork()}}.}

\item{effects}{An object of class "effectsList.monan" in which the non included effects that should
be tested are specified.}

\item{x}{An object of class "scoretest.monan".}

\item{...}{For internal use only.}
}
\value{
The function \code{scoreTest} returns basic values to calculate
parametric and non-parametric p-values
for each tested effect.

The function \code{print.scoretest.monan} shows parametric and non-parametric p-values
for each tested effect.
}
\description{
Based on an estimated model, a score-type test is available that shows whether
statistics representing non-included effects are well represented. If this is
not the case, it is likely that including them will result in significant estimates.
}
\examples{
\donttest{
# test whether other effects should be included
myEffects2 <- createEffects(myState) |>
  addEffect(transitivity_min)

test_ME.2 <- scoreTest(myResDN, myEffects2)
}
\donttest{
test_ME.2
}
}
\seealso{
\code{\link[=createEffectsObject]{createEffectsObject()}}
}
