% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{reorder_taxa_pq}
\alias{reorder_taxa_pq}
\title{Reorder taxa in otu_table/tax_table/refseq slot of a phyloseq object}
\usage{
reorder_taxa_pq(physeq, names_ordered, remove_phy_tree = FALSE)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{names_ordered}{(required): Names of the taxa (must be the same
as taxa in \code{taxa_names(physeq)}) in a given order}

\item{remove_phy_tree}{(logical, default FALSE) If TRUE, the phylogenetic
tree is removed. It is}
}
\value{
A phyloseq object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Note that the taxa order in a physeq object with a tree is locked by
the order of leaf in the phylogenetic tree.
}
\examples{

data_fungi_ordered_by_genus <- reorder_taxa_pq(
  data_fungi,
  taxa_names(data_fungi)[order(as.vector(data_fungi@tax_table[, "Genus"]))]
)

data_fungi_mini_asc_ordered_by_abundance <- reorder_taxa_pq(
  data_fungi_mini,
  taxa_names(data_fungi_mini)[order(taxa_sums(data_fungi_mini))]
)
}
\author{
Adrien Taudière
}
