% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div_test.R
\name{ancombc_pq}
\alias{ancombc_pq}
\title{Run ANCOMBC2 on phyloseq object}
\usage{
ancombc_pq(physeq, fact, levels_fact = NULL, tax_level = "Class", ...)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{(required) Name of the factor in \code{physeq@sam_data} used to plot
different lines}

\item{levels_fact}{(default NULL) The order of the level in the factor.
Used for reorder levels and select levels (filter out levels not present
en levels_fact)}

\item{tax_level}{The taxonomic level passed on to \code{\link[ANCOMBC:ancombc2]{ANCOMBC::ancombc2()}}}

\item{...}{Other arguments passed on to \code{\link[ANCOMBC:ancombc2]{ANCOMBC::ancombc2()}} function.}
}
\value{
The result of \code{\link[ANCOMBC:ancombc2]{ANCOMBC::ancombc2()}} function
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A wrapper for the \code{\link[ANCOMBC:ancombc2]{ANCOMBC::ancombc2()}} function
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{ANCOMBC::ancombc2()} if you
use this function.
}
\examples{
\donttest{
res_height <- ancombc_pq(
  data_fungi_mini,
  fact = "Height",
  levels_fact = c("Low", "High"),
  verbose = TRUE
)

ggplot(
  res_height$res,
  aes(
    y = reorder(taxon, lfc_HeightHigh),
    x = lfc_HeightHigh,
    color = diff_HeightHigh
  )
) +
  geom_vline(xintercept = 0) +
  geom_segment(aes(
    xend = 0, y = reorder(taxon, lfc_HeightHigh),
    yend = reorder(taxon, lfc_HeightHigh)
  ), color = "darkgrey") +
  geom_point()

res_time <- ancombc_pq(
  data_fungi_mini,
  fact = "Time",
  levels_fact = c("0", "15"),
  tax_level = "Family",
  verbose = TRUE
)
}
}
\author{
Adrien Taudière
}
