% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{hill_curves_pq}
\alias{hill_curves_pq}
\title{Hill Diversities and Corresponding Accumulation Curves for phyloseq}
\usage{
hill_curves_pq(
  physeq,
  merge_sample_by = NULL,
  color_fac = NULL,
  hill_scales = c(0, 0.25, 0.5, 1, 2, 4, 8, 16, 32, 64, Inf),
  nperm = NULL,
  na_remove = TRUE,
  wrap_factor = TRUE,
  plot_legend = TRUE,
  linewidth = 2,
  size_point = 2,
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{merge_sample_by}{a vector to determine which samples to merge using
the \code{\link[=merge_samples2]{merge_samples2()}} function.  Need to be in \code{physeq@sam_data}}

\item{color_fac}{(optional): The variable to color the barplot. For ex.
same as fact. If merge_sample_by is set, color_fac must be nested in
the merge_sample_by factor. See examples.}

\item{hill_scales}{Scales of Rényi diversity.}

\item{nperm}{(int Default NULL) If a integer is set to nperm, nperm
permutation are computed to draw confidence interval for each curves.
The function use \code{\link[vegan:renyi]{vegan::renyi()}} if nperm is NULL and
\code{\link[vegan:renyi]{vegan::renyiaccum()}} else.}

\item{na_remove}{(logical, default FALSE) If set to TRUE, remove samples with
NA in the variables set in merge_sample_by. Not used if merge_sample_by is
NULL.}

\item{wrap_factor}{(logical, default TRUE) Do the plot is wrap by the factor}

\item{plot_legend}{(logical, default TRUE) If set to FALSE,
no legend are plotted.}

\item{linewidth}{(int, default 2) The linewidth of lines.}

\item{size_point}{(int, default 1) The size of the point.}

\item{...}{Other arguments passed on to \code{\link[vegan:renyi]{vegan::renyi()}} function or
\code{\link[vegan:renyi]{vegan::renyiaccum()}} if nperm is not NULL.}
}
\value{
A ggplot2 object
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Basically a wrapper of \code{\link[vegan:renyi]{vegan::renyi()}} and
\code{\link[vegan:renyi]{vegan::renyiaccum()}} functions
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{\link[vegan:renyi]{vegan::renyi()}} or
\code{\link[vegan:renyi]{vegan::renyiaccum()}} functions
}
\examples{
if (requireNamespace("vegan")) {
  hill_curves_pq(data_fungi_mini, merge_sample_by = "Time")
  hill_curves_pq(data_fungi_mini, color_fac = "Time", plot_legend = FALSE)
  hill_curves_pq(data_fungi_mini,
    color_fac = "Time", plot_legend = FALSE,
    nperm = 9, size_point = 1, linewidth = 0.5
  )

  hill_curves_pq(data_fungi_mini,
    nperm = 9, plot_legend = FALSE, size_point = 1,
    linewidth = 0.5
  )
  hill_curves_pq(data_fungi_mini, "Height",
    hill_scales = c(0, 1, 2, 8), plot_legend = FALSE
  )
  hill_curves_pq(data_fungi_mini, "Height",
    hill_scales = c(0, 0.5, 1, 2, 4, 8),
    nperm = 9
  )
  hill_curves_pq(data_fungi_mini, "Height", nperm = 9, wrap_factor = FALSE)

  data_fungi_mini@sam_data$H_T <- paste0(
    data_fungi_mini@sam_data$Height,
    "_", data_fungi_mini@sam_data$Time
  )
  merge_samples2(data_fungi_mini, "H_T")
  hill_curves_pq(data_fungi_mini, "H_T", color_fac = "Time", nperm = 9)
}
}
\author{
Adrien Taudière
}
