% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryStatistics.R
\name{get_islandMeanFreqM}
\alias{get_islandMeanFreqM}
\title{Calculate the Mean Frequency of Methylated Sites in Islands}
\usage{
get_islandMeanFreqM(index_islands, data, sample_n, categorized_data = FALSE)
}
\arguments{
\item{index_islands}{A vector containing the structural indices for islands.}

\item{data}{A list containing methylation states at tree tips for each genomic structure (island / non-island)
For a single tip: \code{data[[structure]]}.
For multiple tips: \code{data[[tip]][[structure]]}.
Each element contains the methylation states at the sites in a given tip and structure
represented as 0, 0.5 or 1 (for unmethylated, partially-methylated and methylated).
If methylation states are not represented as 0, 0.5, 1 they are categorized
as 0 when value equal or under 0.2
0.5 when value between 0.2 and 0.8
and 1 when value over 0.8.
For customized categorization thresholds use \code{categorize_siteMethSt}}

\item{sample_n}{The number of samples (tips) to process.}

\item{categorized_data}{Logical defaulted to FALSE.
TRUE to skip redundant categorization when methylation states are represented as 0, 0.5, and 1.}
}
\value{
A numeric value representing the mean frequency of methylated sites in the islands.
}
\description{
This function computes the mean frequency of methylated sites (with methylation state 1)
for a set of structures identified as islands.
}
\examples{
# Example usage:
index_islands <- c(1, 3)
data <- list(
  list(c(0.5, 1, 0.5), c(0, 0.5, 1), c(1, 0, 0.5)), # tip 1
  list(c(0.5, 0.5, 0), c(1, 0.5, 0.5), c(0.5, 0.5, 1)) # tip 2
)
sample_n <- 2
get_islandMeanFreqM(index_islands, data, sample_n, categorized_data = TRUE)

}
