% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateZigZagIndex.R
\name{calculateZigZagIndex}
\alias{calculateZigZagIndex}
\title{Calculate the Zig-Zag Index (of a Chromatographic Peak)}
\usage{
calculateZigZagIndex(peakData, pts)
}
\arguments{
\item{peakData}{A vector containing characteristic information about a chromatographic peak - including the retention time range}

\item{pts}{A 2D matrix containing the retention time and intensity values of a chromatographic peak}
}
\value{
The Zig-Zag Index value (double)
}
\description{
Calculates the Zig-Zag Index of the integrated region of a chromatographic peak. The Zig-Zag Index is found by calculating the sum of
the slope changes between neighboring points normalized by the average intensity of the peak boundaries.
}
\details{
This function repurposed from Zhang et al. For details, see Zhang, W., & Zhao, P. X. (2014). Quality evaluation of extracted
ion chromatograms and chromatographic peaks in liquid chromatography/mass spectrometry-based metabolomics data. BMC Bioinformatics,
15(Suppl 11), S5. https://doi.org/10.1186/1471-2105-15-S11-S5
}
\examples{
# Calculate ZigZag Index for a peak
data(ex_pts)
data(ex_peakData)
zigZagIndex <- calculateZigZagIndex(peakData = ex_peakData, pts = ex_pts)

}
