\name{print_mesh}
\alias{print_mesh}
\title{Print information for a list of mesh objects}
\description{Print the information stored in a list of observer/mesh objects. This includes the respective number of vertices and triangles of the meshes as well as their volume and centroid.}
\usage{
print_mesh(x)
}
\arguments{
  \item{x}{\code{list} of observer/mesh objects with a structure as generated by \code{\link[MeshAgreement]{read_mesh}}.}
}
\details{Use \code{\link[MeshAgreement]{print_mesh_one}} for printing information for a single mesh object. Use \code{\link[MeshAgreement]{print_mesh_obs}} for printing information for a list of meshes.}
\value{Text output on the console.}
\seealso{
\code{\link[MeshAgreement]{read_mesh}},
\code{\link[MeshAgreement]{print_mesh_one}},
\code{\link[MeshAgreement]{print_mesh_obs}}
}
\examples{
heartL <- mesh3dL_to_cgalMeshL(data_heart_obsL)
print_mesh(heartL)
}
