% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-sampling.R
\name{.flagOutliers}
\alias{.flagOutliers}
\title{Flag outliers in vectorized data}
\usage{
.flagOutliers(df = NULL, parameter = NULL, width = 23, thresholdMin = 8)
}
\arguments{
\item{df}{Data frame.}

\item{parameter}{Data frame parameter to use for outlier detection.}

\item{width}{Width the rolling window.}

\item{thresholdMin}{Minimum threshold value used to detect outliers.}
}
\value{
A dataframe with an additional column identifying outliers.
}
\description{
This function uses Hampel filter outlier detection to flag
outliers in \code{parameter} column of the incoming dataframe. The
\code{width} and \code{thresholdMin} parameters as passed on to the
\code{\link[MazamaRollUtils]{findOutliers}} function.

An additional boolean column named \code{<parameter>_outlierFlag} is added
to the dataframe. This column will have \code{TRUE} whenever an outlier is
detected for the chosen \code{parameter}.

See \code{\link[MazamaRollUtils]{findOutliers}} for further details.
}
\keyword{internal}
