% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts_arrange.R
\name{mts_arrange}
\alias{mts_arrange}
\title{Order \emph{mts} time series by metadata values}
\usage{
mts_arrange(mts, ...)
}
\arguments{
\item{mts}{\emph{mts} object.}

\item{...}{variables in \code{mts$meta}.}
}
\value{
A reorderd version of the incoming \emph{mts} time series object.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
The variable(s) in \code{...} are used to specify columns of
\code{mts$meta} to use for ordering. Under the hood, this
function uses \code{\link[dplyr]{arrange}} on \code{mts$meta} and then
reorders \code{mts$data} to match.
}
\examples{
library(MazamaTimeSeries)

example_mts$meta$latitude[1:10]

# Filter for all labels with "SCSH"
byElevation <-
  example_mts \%>\%
  mts_arrange(latitude)

byElevation$meta$latitude[1:10]

}
